IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[NR_AUTORIZADOR] [varchar](60) NOT NULL,
 CONSTRAINT [PK_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC,
	[NR_AUTORIZADOR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] ADD  CONSTRAINT [DF_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] ADD  CONSTRAINT [DF_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] ADD  CONSTRAINT [DF_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] ADD  CONSTRAINT [DF_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_NR_AUTORIZADOR]  DEFAULT ('') FOR [NR_AUTORIZADOR]

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA] CHECK CONSTRAINT [FK_EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA_EST_NF_SAI]
end
